#ifndef _BLOCK_TYPE_
#define _BLOCK_TYPE_
typedef struct BlockType BlockType;
#include "common.h"
#include "block.h"
struct BlockType {
    char * name;
    float xs, ys, zs;
    bool dynamic /* in the dynamic list - must be set for any block that can move */;
    bool lift /* can be lifted */;
    bool transparent /* in the transparent list */;
    bool fixed /* cannot be pushed/pulled */;
    bool invisible;
    bool animated;
    LandArray * bitmaps;
    int btid;
    void(* tick)(Block *);
    bool(* touch)(Block *, Block *, float, float, float);
    void(* destroy)(Block *);
    Block * (* allocate)(void);
    void(* post_init)(Block *);
};
extern LandArray * block_types;
BlockType* blocktype_new(char const * name, float xs, float ys, float zs, void(* tick)(Block *), bool(* touch)(Block *, Block *, float, float, float), void(* destroy)(Block *), Block * (* allocate)(void), void(* post_init)(Block *));
void blocktype_destroy(BlockType * self);
bool blocktype_preload(BlockType * self);
int block_type_flower(BlockType * self);
BlockType* block_flower(int i);
BlockType* block_type_by_name(str name);
#endif
